
import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*

/**
 * Content URL extractor plugin for packers.com video feeds.
 *
 * @author Tyler Raulin
 *
 */
class Packers extends FeedItemUrlExtractor {
    
    final VALID_FEED_URL = 'http://www.packers.com/cda-web/rss-module.*'
    
    String getExtractorName() {
        return 'Packers'
    }
    
    boolean extractorMatches(URL feedUrl) {
        return feedUrl ==~ VALID_FEED_URL
    }
    
    ContentURLContainer extractUrl(Map links, PreferredQuality requestedQuality) {
    
        def linkUrl = links.default
        
        def matcher = linkUrl =~ '^http(s)*://www.packers.com/media-center/videos/.*$'
        
        assert matcher != null
        assert matcher.hasGroup()
        
        def videoId = matcher[0]
        // load the video web page and look for stream URL
        String pageHtml = linkUrl.getText()
        def seqVarMatcher = pageHtml =~ 'http://prod.video.+mp4'
        assert seqVarMatcher != null
        def contentUrl = URLDecoder.decode(seqVarMatcher[0],'ISO-8859-1')
        return new ContentURLContainer(contentUrl: contentUrl)
    }
    
    static void main(args) {
        // this is just to test
        Packers extractor = new Packers()
        
        assert extractor.extractorMatches( new URL("http://www.packers.com/cda-web/rss-module.htm?tagName=Videos") )
        assert !extractor.extractorMatches( new URL("http://google.com/feeds/api/standardfeeds/top_rated?time=today") )
        
        Map videoLinks = ['default': new URL('http://www.packers.com/media-center/videos/Inside-Lambeau-with-Marshall-Newhouse/41469dbb-5d51-4636-a442-58e24206cbf6')]
        ContentURLContainer result = extractor.extractUrl(videoLinks, PreferredQuality.MEDIUM)
        println "Result: $result"         
    }
}